% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fssa.r
\name{fssa}
\alias{fssa}
\title{Functional Singular Spectrum Analysis (FSSA)}
\usage{
fssa(Y, L = Y$N/2, ntriples = 20, type = "ufssa")
}
\arguments{
\item{Y}{an object of class \code{\link{funts}}.}

\item{L}{a positive integer, the window length, the default is half of FTS length.}

\item{ntriples}{a positive integer, the number of eigentriples for the
decomposition.}

\item{type}{a string indicating the type of FSSA: "ufssa" (default for
univariate FTS) or "mfssa" (default for multivariate FTS).}
}
\value{
An object of class \code{fssa}, containing functional objects,
eigenvalues, window length, and original data.
}
\description{
This function performs the decomposition (embedding and functional SVD steps)
for univariate (ufssa) or multivariate (mfssa) functional singular spectrum
analysis based on the input data type. The input can be a univariate or
multivariate functional time series (\code{\link{funts}}) object.
}
\examples{
data("Callcenter")

# FSSA Decomposition step:
L <- 28
U <- fssa(Callcenter, L)
plot(U, type = "values", d = 10)
plot(U, type = "vectors", d = 4)
plot(U, type = "paired", d = 6)
plot(U, type = "lcurves", d = 4, vars = 1)
plot(U, type = "lheats", d = 4)
plot(U, type = "wcor", d = 10)
plotly_funts(U$Lsingf[[1]])
plot(U$Lsingf[[2]])

\dontrun{
#--------------- Multivariate FSSA Example on bivariate -----------------------------
## temperature curves and smoothed images of vegetation
data("Montana")

# MFSSA Decomposition step:
L <- 45
U <- fssa(Montana, L)
plot(U, type = "values", d = 10)
plot(U, type = "vectors", d = 4)
plot(U, type = "lheats", d = 4)
plot(U, type = "lcurves", d = 4, vars = 1)
plot(U, type = "paired", d = 6)
plot(U, type = "periodogram", d = 4)
plot(U, type = "wcor", d = 10)
plotly_funts(U$Lsingf[[1]])
plot(U$Lsingf[[2]])

}
}
