% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_github_data.R
\name{loadAustinData}
\alias{loadAustinData}
\title{Load Austin Temperature Data from GitHub Repository}
\format{
Containing two matrix objects:
\describe{
  \item{Austin Temperature Data}{A 24 by 607 matrix of discrete samplings of intraday hourly temperature curves, one day per month.}
  \item{Utqiagvik Temperature Data}{A 24 by 607 matrix of discrete samplings of intraday hourly temperature curves, one day per month.}
}
}
\usage{
loadAustinData()
}
\description{
This function retrieves the Austin Temperature dataset from a GitHub repository hosted at
https://github.com/haghbinh/dataset/Rfssa_dataset. Hosting datasets on GitHub
rather than including them in the Rfssa R package conserves storage space.
The Austin Temperature dataset contains intraday hourly temperature curves
measured in degrees Celsius from January 1973 to July 2023, recorded once per month.
The returned object is a raw dataset in `list` format;
}
\examples{
Austin_raw <- loadAustinData()
str(Austin_raw)


}
\references{
Trinka, J., Haghbin, H., Shang, H., Maadooliat, M. (2023). Functional Time Series Forecasting: Functional Singular Spectrum Analysis Approaches. Stat, e621.
}
