% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funts_methods.R
\name{plot.funts}
\alias{plot.funts}
\title{Plot Functional Time Series (funts) Data}
\usage{
\method{plot}{funts}(
  x,
  npts = 100,
  obs = 1,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  type = "l",
  lty = 1,
  ...
)
}
\arguments{
\item{x}{An object of class \code{funts}.}

\item{npts}{Number of grid points for the plots.}

\item{obs}{Observation number (for two-dimensional domains).}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Main title for the plot.}

\item{type}{Type of plot ("l" for line, "p" for points, etc.).}

\item{lty}{Line type (1 for solid, 2 for dashed, etc.).}

\item{...}{Additional graphical parameters passed to plotting functions.}
}
\description{
Create visualizations of Functional Time Series (funts) data, supporting both one-dimensional and two-dimensional domains.
}
\details{
This function enables the creation of visualizations for Functional Time Series (funts) data. It supports both one-dimensional and two-dimensional domains.

For one-dimensional domains, line plots are used, while for two-dimensional domains, image plots are employed.
}
\examples{
# Example with one-dimensional domain
data("Callcenter")
plot(Callcenter, lwd = 2, col = "deepskyblue4", main = "Call Center Data")

# Example with two-dimensional domain
data("Montana")
plot(Montana, obs = 2, main = c("Temperature Curves", "NDVI Images,"))

}
\seealso{
\code{\link{funts}}, \code{\link{Callcenter}}, \code{\link{Montana}}
}
