% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_features}
\alias{search_features}
\title{Search for Features}
\usage{
search_features(client, feature_set_id = NULL, parent_id = NULL,
  feature_types = NULL, reference_name = NULL, gene_symbol = NULL,
  name = NULL, start = NULL, end = NULL, page_size = NULL,
  page_token = NULL)
}
\arguments{
\item{client}{A ga4gh_client object}

\item{feature_set_id}{The ID of the Feature Set to search within. Either feature_set_id or parent_id must be non-null.}

\item{parent_id}{Restricts the search to direct children of the given parent feature ID.
Either feature_set_id or parent_id must be non-null.}

\item{feature_types}{A list of feature types.  If specified, this query matches only annotations whose
feature_type matches one of the provided ontology terms.}

\item{reference_name}{Only return features on the reference with this name}

\item{gene_symbol}{Only return features with matching the provided gene symbol (case-sensitive, exact match).}

\item{name}{Only returns features with this name (case-sensitive, exact match).}

\item{start}{The beginning of the window (0-based, inclusive) for which overlapping features should be returned.
Genomic positions are non-negative integers less than reference length.}

\item{end}{The end of the window (0-based, exclusive) for which overlapping features should be returned.}

\item{page_size}{Specifies the maximum number of results to return in a single page.
If unspecified, the client default will be used.}

\item{page_token}{The continuation token, which is used to page through
large result sets. To get the next page of results, set this parameter to
the value of nextPageToken from the previous response.}
}
\description{
Search for Features
}
\examples{

ref_client <- ga4gh_client("http://1kgenomes.ga4gh.org", api_location = "")

\dontrun{

library(magrittr)
## Find a dataset to search in
datasets <- ref_client \%>\% search_datasets() \%>\% content()
d_id <- datasets$datasets[[1]]$id

## Find a feature set to search in
feature_sets <- ref_client \%>\% search_feature_sets(d_id) \%>\% content()
fs_id <- feature_sets$featureSets[[1]]$id

## Search the for features in the feature set
features <- ref_client \%>\% search_features(fs_id) \%>\% content()
features$features[[1]]

}

}

