% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgff.R
\name{saf_from_gff}
\alias{saf_from_gff}
\title{Creates a SAF file from a GTF/GFF3 features for the given pairs of blocks and features}
\usage{
saf_from_gff(
  inFile,
  outFile,
  fileType = c("AUTO", "GFF3", "GTF"),
  forceOverwrite = FALSE,
  features = c("gene > exon"),
  sep = ">"
)
}
\arguments{
\item{inFile}{Path to the input gff file}

\item{outFile}{Path to the output SAF file, if not provided the output path will be the input path with the suffix ".feature1-block1.feature2-block2(...).saf"}

\item{fileType}{Version of the input file (GTF/GFF3). Default AUTO: determined from the file name.}

\item{forceOverwrite}{If output file exists, overwrite the existing file. (default FALSE)}

\item{features}{Vector of pairs of features/blocks, separated by '>' (see sep argument). In the case of features without defined blocks, only the feature is needed (see example)}

\item{sep}{Separator of each "feature" and "block" provided in the feature argument (default '>')}
}
\value{
Path to the generated SAF file
}
\description{
This function creates a SAF file from a GTF/GFF3 features for the given blocks
and features
}
\examples{
test_gff3<-system.file("extdata", "AthSmall.gff3", package="Rgff")
## Default usage, extract gene features by exon blocks 
saf_from_gff(test_gff3)
## Define only feature without block to count reads within the whole genomic locus 
saf_from_gff(test_gff3, features=c("gene"))
## Define multiple features for counting readsoverlapping only in exonic regions 
saf_from_gff(test_gff3, features=c("gene > exon", "ncRNA_gene > exon"))
}
