% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_comment_reactions.R
\name{post_comment_reactions}
\alias{post_comment_reactions}
\title{POST comment reactions}
\usage{
post_comment_reactions(file_key, comment_id, emoji)
}
\arguments{
\item{file_key}{string. The key that a Figma file is referred by.}

\item{comment_id}{string. If there is one, the comment to respond to. You
cannot reply to a remark that is a reply to itself (a reply has a parent id),
thus this must be a root comment.}

\item{emoji}{string. The emoji type of reaction as a string enum :eyes:,
:heart_eyes:, :heavy_plus_sign:, :+1:, :-1:, :joy: and :fire:}
}
\value{
S3 object of class `rigma_post_comment_reactions`. Contains the parsed
JSON response with fields `error`, `status`, and `i18n`.
}
\description{
Posts a new comment reaction on a file comment.
}
\examples{
\dontshow{if (Sys.getenv("FIGMA_ACCESS_TOKEN") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
#navigate to  file and get key from url
file_key <- "sFHgQh9dL6369o5wrZHmdR"
first_comment_id <- get_comments(file_key)$comments[[1]]$id
post_comment_reactions(file_key, first_comment_id, ":eyes:")
}
\dontshow{\}) # examplesIf}
}
