/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.util;

import java.util.ArrayList;
import org.apache.kahadb.util.LinkedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedNodeList<T extends LinkedNode<T>> {
    T head;
    int size;

    public boolean isEmpty() {
        return this.head == null;
    }

    public void addLast(T node) {
        ((LinkedNode)node).linkToTail(this);
    }

    public void addFirst(T node) {
        ((LinkedNode)node).linkToHead(this);
    }

    public T getHead() {
        return this.head;
    }

    public T getTail() {
        return ((LinkedNode)this.head).prev;
    }

    public void clear() {
        while (this.head != null) {
            ((LinkedNode)this.head).unlink();
        }
    }

    public void addLast(LinkedNodeList<T> list) {
        if (list.isEmpty()) {
            return;
        }
        if (this.head == null) {
            this.head = list.head;
            this.reparent(list);
        } else {
            ((LinkedNode)this.getTail()).linkAfter(list);
        }
    }

    public void addFirst(LinkedNodeList<T> list) {
        if (list.isEmpty()) {
            return;
        }
        if (this.head == null) {
            this.reparent(list);
            this.head = list.head;
            list.head = null;
        } else {
            ((LinkedNode)this.getHead()).linkBefore(list);
        }
    }

    public T reparent(LinkedNodeList<T> list) {
        this.size += list.size;
        T n = list.head;
        do {
            ((LinkedNode)n).list = this;
        } while ((n = ((LinkedNode)n).next) != list.head);
        list.head = null;
        list.size = 0;
        return n;
    }

    public T rotate() {
        if (this.head == null) {
            return null;
        }
        this.head = ((LinkedNode)this.head).getNextCircular();
        return this.head;
    }

    public void rotateTo(T head) {
        assert (head != null) : "Cannot rotate to a null head";
        assert (((LinkedNode)head).list == this) : "Cannot rotate to a node not linked to this list";
        this.head = head;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (T cur = this.getHead(); cur != null; cur = ((LinkedNode)cur).getNext()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(cur);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public ArrayList<T> toArrayList() {
        ArrayList<T> rc = new ArrayList<T>(this.size);
        for (T cur = this.head; cur != null; cur = ((LinkedNode)cur).getNext()) {
            rc.add(cur);
        }
        return rc;
    }
}

