% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{listCtryNlData}
\alias{listCtryNlData}
\title{List available data}
\usage{
listCtryNlData(ctryCodes = NULL, admLevels = NULL, nlTypes = NULL,
  nlPeriods = NULL, polySrcs = NULL, polyVers = NULL, nlStats = NULL,
  source = "local")
}
\arguments{
\item{ctryCodes}{\code{character} vector of ctryCodes to filter by}

\item{admLevels}{A character vector of admLevels to filter by}

\item{nlTypes}{A character vector of nlTypes to filter by}

\item{nlPeriods}{A character vector of nlPeriods to filter by}

\item{polySrcs}{The source of polygons e.g. GADM or CUST to filter by}

\item{polyVers}{The version of the polygon source to filter by}

\item{nlStats}{The stats to filter by}

\item{source}{Character string. Whether to check data availability "local" or "remote"
Not in use.}
}
\value{
a list of countries and the periods and stats for each
}
\description{
List available data. If source is "local" it lists data cached locally.
    If source is remote lists available data on the remote repository.
}
\examples{
#list all data
listCtryNlData()

#list all data available for KEN
listCtryNlData(ctryCodes = "KEN")

#list all VIIRS.* data available for ECU
listCtryNlData(ctryCodes = "ECU", nlTypes = "VIIRS")

#list available OLS.Y data for KEN and RWA in 2012 & 2013
listCtryNlData(ctryCodes = c("KEN","RWA"), nlPeriods = c("2012", "2013"), nlTypes = "OLS.Y")

}
