% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doProcessing.R
\name{setLogFile}
\alias{setLogFile}
\title{setLogFile}
\usage{
setLogFile(con = stdout())
}
\arguments{
\item{con}{a connection object which inherits from class "connection"}
}
\description{
\code{setLogFile} allows to redirect all log messages to a file
}
\examples{
 \donttest{
  # Redirect all log messages to a temporary file
   outtmp <- tempfile()
   con <- file(outtmp, "wt", encoding = "UTF-8")
   setLogFile(con)
   data_dir <- system.file("extra", package = "Rnmr1D")
   RAWDIR <- file.path(data_dir, "CD_BBI_16P02")
   CMDFILE <- file.path(data_dir, "NP_macro_cmd.txt")
   SAMPLEFILE <- file.path(data_dir, "Samples.txt")
   out <- Rnmr1D::doProcessing(RAWDIR, cmdfile=CMDFILE, samplefile=SAMPLEFILE, ncpu=6)
   close(con)
   readLines(outtmp)
 }
}
