% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiBMA-reg.R
\name{BiBMA.reg}
\alias{BiBMA.reg}
\title{Estimate a Robust Bayesian Meta-Analysis Meta-Regression}
\usage{
BiBMA.reg(
  formula,
  data,
  test_predictors = TRUE,
  study_names = NULL,
  study_ids = NULL,
  standardize_predictors = TRUE,
  priors = NULL,
  rescale_priors = 1,
  priors_effect = set_default_binomial_priors("effect", rescale = rescale_priors),
  priors_heterogeneity = set_default_binomial_priors("heterogeneity", rescale =
    rescale_priors),
  priors_effect_null = set_default_binomial_priors("effect", null = TRUE),
  priors_heterogeneity_null = set_default_binomial_priors("heterogeneity", null = TRUE),
  prior_covariates = set_default_binomial_priors("covariates", rescale = rescale_priors),
  prior_covariates_null = set_default_binomial_priors("covariates", null = TRUE),
  prior_factors = set_default_binomial_priors("factors", rescale = rescale_priors),
  prior_factors_null = set_default_binomial_priors("factors", null = TRUE),
  priors_hierarchical = set_default_binomial_priors("hierarchical"),
  priors_hierarchical_null = set_default_binomial_priors("hierarchical", null = TRUE),
  priors_baseline = set_default_binomial_priors("baseline"),
  priors_baseline_null = set_default_binomial_priors("baseline", null = TRUE),
  algorithm = "bridge",
  chains = 3,
  sample = 5000,
  burnin = 2000,
  adapt = 500,
  thin = 1,
  parallel = FALSE,
  autofit = TRUE,
  autofit_control = set_autofit_control(),
  convergence_checks = set_convergence_checks(),
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{formula}{a formula for the meta-regression model}

\item{data}{a data.frame containing the data for the meta-regression. Note that the
column names have to correspond to the effect sizes (\code{d}, \code{logOR}, \code{OR},
\code{r}, \code{z}), a measure of sampling variability (\code{se}, \code{v}, \code{n},
\code{lCI}, \code{uCI}, \code{t}), and the predictors.
See \code{\link[=combine_data]{combine_data()}} for a complete list of reserved names and additional information
about specifying input data.}

\item{test_predictors}{vector of predictor names to test for the presence
of moderation (i.e., assigned both the null and alternative prior distributions).
Defaults to \code{TRUE}, all predictors are tested using the default
prior distributions (i.e., \code{prior_covariates},
\code{prior_covariates_null}, \code{prior_factors}, and
\code{prior_factors_null}). To only estimate
and adjust for the effect of predictors use \code{FALSE}. If
\code{priors} is specified, any settings in \code{test_predictors}
is overridden.}

\item{study_names}{an optional argument with the names of the studies}

\item{study_ids}{an optional argument specifying dependency between the
studies (for using a multilevel model). Defaults to \code{NULL} for
studies being independent.}

\item{standardize_predictors}{whether continuous predictors should be standardized prior to
estimating the model. Defaults to \code{TRUE}. Continuous predictor standardization is important
for applying the default prior distributions for continuous predictors. Note that the resulting
output corresponds to standardized meta-regression coefficients.}

\item{priors}{named list of prior distributions for each predictor
(with names corresponding to the predictors). It allows users to
specify both the null and alternative hypothesis prior distributions
for each predictor by assigning the corresponding element of the named
list with another named list (with \code{"null"} and
\code{"alt"}).
If only one prior is specified for a given parameter, it is
assumed to correspond to the alternative hypotheses and the default null
hypothesis is specified (i.e., \code{prior_covariates_null} or
\code{prior_factors_null}).
If a named list with only one named prior distribution is provided (either
\code{"null"} or \code{"alt"}), only this prior distribution is used and no
default distribution is filled in.
Parameters without specified prior distributions are assumed to be only adjusted
for using the default alternative hypothesis prior distributions (i.e.,
\code{prior_covariates} or \code{prior_factors}).
If \code{priors} is specified, \code{test_predictors} is ignored.}

\item{rescale_priors}{a re-scaling factor for the prior distributions. The re-scaling
factor allows to adjust the width of all default priors simultaneously. Defaults to \code{1}.}

\item{priors_effect}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "student",   parameters = list(location = 0, scale = 0.58, df = 4))},
based on logOR meta-analytic estimates from the Cochrane Database of Systematic Reviews
\insertCite{bartos2023empirical}{RoBMA}.}

\item{priors_heterogeneity}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the alternative hypothesis. Defaults to
\code{prior(distribution = "invgamma",  parameters = list(shape = 1.77, scale = 0.55))} that
is based on heterogeneities of logOR estimates from the Cochrane Database of Systematic Reviews
\insertCite{bartos2023empirical}{RoBMA}.}

\item{priors_effect_null}{list of prior distributions for the effect size (\code{mu})
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero,
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{priors_heterogeneity_null}{list of prior distributions for the heterogeneity \code{tau}
parameter that will be treated as belonging to the null hypothesis. Defaults to
a point null hypotheses at zero (a fixed effect meta-analytic models),
\code{prior(distribution = "point", parameters = list(location = 0))}.}

\item{prior_covariates}{a prior distributions for the regression parameter
of continuous covariates on the effect size under the alternative hypothesis
(unless set explicitly in \code{priors}). Defaults to a relatively wide normal
distribution \code{prior(distribution = "normal", parameters = list(mean = 0, sd = 0.25))}.}

\item{prior_covariates_null}{a prior distributions for the regression parameter
of continuous covariates on the effect size under the null hypothesis
(unless set explicitly in \code{priors}). Defaults to a no effect
\code{prior("spike",  parameters = list(location = 0))}.}

\item{prior_factors}{a prior distributions for the regression parameter
of categorical covariates on the effect size under the alternative hypothesis
(unless set explicitly in \code{priors}). Defaults to a relatively wide
multivariate normal distribution specifying differences from the mean contrasts
\code{prior_factor("mnormal", parameters = list(mean = 0, sd = 0.25), contrast = "meandif")}.}

\item{prior_factors_null}{a prior distributions for the regression parameter
of categorical covariates on the effect size under the null hypothesis
(unless set explicitly in \code{priors}). Defaults to a no effect
\code{prior("spike",  parameters = list(location = 0))}.}

\item{priors_hierarchical}{list of prior distributions for the correlation of random effects
(\code{rho}) parameter that will be treated as belonging to the alternative hypothesis. This setting allows
users to fit a hierarchical (three-level) meta-analysis when \code{study_ids} are supplied.
Note that this is an experimental feature and see News for more details. Defaults to a beta distribution
\code{prior(distribution = "beta", parameters = list(alpha = 1, beta = 1))}.}

\item{priors_hierarchical_null}{list of prior distributions for the correlation of random effects
(\code{rho}) parameter that will be treated as belonging to the null hypothesis. Defaults to \code{NULL}.}

\item{priors_baseline}{prior distributions for the alternative hypothesis about
intercepts (\code{pi}) of each study. Defaults to \code{NULL}.}

\item{priors_baseline_null}{prior distributions for the null hypothesis about
intercepts (\code{pi}) for each study. Defaults to an independent uniform prior distribution
for each intercept \code{prior("beta", parameters = list(alpha = 1, beta = 1), contrast = "independent")}.}

\item{algorithm}{a string specifying the algorithm used for the model averaging. Defaults to \code{"bridge"}
which results in estimating individual models using JAGS and computing the marginal likelihood using bridge
sampling. An alternative is \code{"ss"} which uses spike and slab like parameterization to approximate the
Bayesian model averaging with a single model. Note that significantly more \code{sample}, \code{burnin}, and
\code{adapt} iterations are needed for the \code{"ss"} algorithm.}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{sample}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{burnin}{a number of burnin iterations of the MCMC algorithm.
Defaults to \code{2000}.}

\item{adapt}{a number of adaptation iterations of the MCMC algorithm.
Defaults to \code{500}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{autofit}{whether the model should be fitted until the convergence
criteria (specified in \code{autofit_control}) are satisfied. Defaults to
\code{TRUE}.}

\item{autofit_control}{allows to pass autofit control settings with the
\code{\link[=set_autofit_control]{set_autofit_control()}} function. See \code{?set_autofit_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{RoBMA.reg} returns an object of class 'RoBMA.reg'.
}
\description{
\code{RoBMA} is used to estimate a robust Bayesian
meta-regression. The interface allows a complete customization of
the ensemble with different prior (or list of prior) distributions
for each component.
}
\details{
\code{\link[=BiBMA.reg]{BiBMA.reg()}} function estimates the Bayesian model-averaged binomial meta-regression.
See \href{../doc/MetaRegression.html}{\code{vignette("/MetaRegression", package = "RoBMA")}}
vignette describes how to use the similar \code{\link[=RoBMA.reg]{RoBMA.reg()}} function to fit Bayesian meta-regression ensembles.
See \insertCite{bartos2023robust;textual}{RoBMA} for more details about the methodology and
\code{\link[=BiBMA]{BiBMA()}} for more details about the function options. By default, the function standardizes
continuous predictors. As such, the output should be interpreted as standardized meta-regression
coefficients.

Generic \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=print.RoBMA]{print.RoBMA()}}, and \code{\link[=plot.RoBMA]{plot.RoBMA()}} functions are
provided to facilitate manipulation with the ensemble. A visual check of the
individual model diagnostics can be obtained using the \code{\link[=diagnostics]{diagnostics()}} function.
The fitted model can be further updated or modified by \code{\link[=update.RoBMA]{update.RoBMA()}} function.
Estimated marginal means can be computed by \code{\link[=marginal_summary]{marginal_summary()}} function and
visualized by the \code{\link[=marginal_plot]{marginal_plot()}} function.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=BiBMA]{BiBMA()}} \code{\link[=summary.RoBMA]{summary.RoBMA()}}, \code{\link[=update.BiBMA]{update.BiBMA()}}, \code{\link[=check_setup.reg]{check_setup.reg()}}
}
