% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.RoBTT}
\alias{plot.RoBTT}
\title{Plots a fitted 'RoBTT' object}
\usage{
\method{plot}{RoBTT}(
  x,
  parameter = "mu",
  transform_rho = FALSE,
  conditional = FALSE,
  plot_type = "base",
  prior = FALSE,
  dots_prior = NULL,
  ...
)
}
\arguments{
\item{x}{a fitted 'RoBTT' object}

\item{parameter}{a parameter to be plotted. Defaults to
\code{"delta"} (for the effect size). The additional options
are \code{"rho"} (for the heterogeneity),
\code{"nu"} (for the degrees of freedom).}

\item{transform_rho}{whether rho parameter should be translated
into log standard deviation ratio}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{prior}{whether prior distribution should be added to
figure. Defaults to \code{FALSE}.}

\item{dots_prior}{list of additional graphical arguments
to be passed to the plotting function of the prior
distribution. Supported arguments are \code{lwd},
\code{lty}, \code{col}, and \code{col.fill}, to adjust
the line thickness, line type, line color, and fill color
of the prior distribution respectively.}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{plot.RoBTT} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{plot.RoBTT} allows to visualize
different \code{"RoBTT"} object parameters in various
ways. See \code{type} for the different model types.
}
\examples{
data("fertilization", package = "RoBTT")
fit <- RoBTT(
  x1       = fertilization$Self,
  x2       = fertilization$Crossed,
  prior_delta = prior("cauchy", list(0, 1/sqrt(2))),
  prior_rho   = prior("beta",   list(3, 3)),
  likelihood  = "normal",
  seed        = 1, 
  chains      = 1,
  warmup      = 1000,
  iter        = 2000,
  control     = set_control(adapt_delta = 0.95)
)

# plot the model-averaged effect size estimate
plot(fit, parameter = "delta")

# plot prior and posterior of the conditional effect size estimate
plot(fit, parameter = "delta", conditional = TRUE, prior = TRUE)

}
\seealso{
\code{\link[=RoBTT]{RoBTT()}}
}
