% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmrobdet.R
\name{refine.sm}
\alias{refine.sm}
\title{IRWLS iterations for S- or M-estimators}
\usage{
refine.sm(
  x,
  y,
  initial.beta,
  initial.scale,
  k = 50,
  conv = 1,
  b,
  cc,
  family,
  step = "M",
  tol
)
}
\arguments{
\item{x}{design matrix}

\item{y}{vector of responses}

\item{initial.beta}{vector of initial regression estimates}

\item{initial.scale}{initial residual scale estimate. If missing the (scaled) median of
the absolute residuals is used.}

\item{k}{maximum number of refining steps to be performed}

\item{conv}{an integer indicating whether to check for convergence (1) at each step,
or to force running k steps (0)}

\item{b}{tuning constant for the M-scale estimator, used if iterations are for an S-estimator.}

\item{cc}{tuning constant for the rho function.}

\item{family}{string specifying the name of the family of loss function to be used (current
valid options are "bisquare", "opt" and "mopt")}

\item{step}{a string indicating whether the iterations are to compute an S-estimator
('S') or an M-estimator ('M')}

\item{tol}{tolerance to detect convergence (relative difference of consecutive vectors of parameters)}
}
\value{
A list with the following components:
\item{beta.rw}{The updated vector of regression coefficients}
\item{scale.rw}{The corresponding estimated residual scale}
\item{converged}{A logical value indicating whether the algorithm
converged}
}
\description{
This function performs iterative improvements for S- or
M-estimators.
}
\details{
This function performs iterative improvements for S- or
M-estimators. Both iterations are formally the same, the
only difference is that for M-iterations the residual
scale estimate remains fixed, while for S-iterations
it is updated at each step. In this case, we follow
the Fast-S algorithm of Salibian-Barrera and Yohai
an use one step updates for the M-scale, as opposed
to a full computation. This as internal function.
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}.
}
