% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{robyn_refresh}
\alias{robyn_refresh}
\alias{print.robyn_refresh}
\alias{plot.robyn_refresh}
\title{Build Refresh Model}
\usage{
robyn_refresh(
  json_file = NULL,
  robyn_object = NULL,
  dt_input = NULL,
  dt_holidays = Robyn::dt_prophet_holidays,
  refresh_steps = 4,
  refresh_mode = "manual",
  refresh_iters = 1000,
  refresh_trials = 3,
  plot_folder = NULL,
  plot_pareto = TRUE,
  version_prompt = FALSE,
  export = TRUE,
  calibration_input = NULL,
  ...
)

\method{print}{robyn_refresh}(x, ...)

\method{plot}{robyn_refresh}(x, ...)
}
\arguments{
\item{json_file}{Character. JSON file to import previously exported inputs
(needs \code{dt_input} and \code{dt_holidays} parameters too).}

\item{robyn_object}{Character or List. Path of the \code{Robyn.RDS} object
that contains all previous modeling information or the imported list.}

\item{dt_input}{data.frame. Should include all previous data and newly added
data for the refresh.}

\item{dt_holidays}{data.frame. Raw input holiday data. Load standard
Prophet holidays using \code{data("dt_prophet_holidays")}.}

\item{refresh_steps}{Integer. It controls how many time units the refresh
model build move forward. For example, \code{refresh_steps = 4} on weekly data
means the \code{InputCollect$window_start} & \code{InputCollect$window_end}
move forward 4 weeks. If \code{refresh_steps} is smaller than the number of
newly provided data points, then Robyn would only use the first N steps of the
new data.}

\item{refresh_mode}{Character. Options are "auto" and "manual". In auto mode,
the \code{robyn_refresh()} function builds refresh models with given
\code{refresh_steps} repeatedly until there's no more data available. I
manual mode, the \code{robyn_refresh()} only moves forward \code{refresh_steps}
only once. "auto" mode has been deprecated when using \code{json_file} input.}

\item{refresh_iters}{Integer. Iterations per refresh. Rule of thumb is, the
more new data added, the more iterations needed. More reliable recommendation
still needs to be investigated.}

\item{refresh_trials}{Integer. Trials per refresh. Defaults to 5 trials.
More reliable recommendation still needs to be investigated.}

\item{plot_folder}{Character. Path for saving plots. Default
to \code{robyn_object} and saves plot in the same directory as \code{robyn_object}.}

\item{plot_pareto}{Boolean. Set to \code{FALSE} to deactivate plotting
and saving model one-pagers. Used when testing models.}

\item{version_prompt}{Logical. If FALSE, the model refresh version will be
selected based on the smallest combined error of normalized NRMSE, DECOMP.RSSD, MAPE.
If \code{TRUE}, a prompt will be presented to the user to select one of the refreshed
models (one-pagers and Pareto CSV files will already be generated).}

\item{export}{Boolean. Export outcomes into local files?}

\item{calibration_input}{data.frame. Optional. Provide experimental results to
calibrate. Your input should include the following values for each experiment:
channel, liftStartDate, liftEndDate, liftAbs, spend, confidence, metric.
You can calibrate any spend or organic variable with a well designed experiment.
You can also use experimental results from multiple channels; to do so,
provide concatenated channel value, i.e. "channel_A+channel_B".
Check "Guide for calibration source" section.}

\item{...}{Additional parameters to overwrite original custom parameters
passed into initial model.}

\item{x}{\code{robyn_refresh()} output.}
}
\value{
List. The Robyn object, class \code{robyn_refresh}.

List. Same as \code{robyn_run()} but with refreshed models.
}
\description{
\code{robyn_refresh()} builds updated models based on
the previously built models saved in the \code{Robyn.RDS} object specified
in \code{robyn_object}. For example, when updating the initial build with 4
weeks of new data, \code{robyn_refresh()} consumes the selected model of
the initial build, sets lower and upper bounds of hyperparameters for the
new build around the selected hyperparameters of the previous build,
stabilizes the effect of baseline variables across old and new builds, and
regulates the new effect share of media variables towards the latest
spend level. It returns the aggregated results with all previous builds for
reporting purposes and produces reporting plots.

You must run \code{robyn_save()} to select and save an initial model first,
before refreshing.

\strong{When should \code{robyn_refresh()} NOT be used:}
The \code{robyn_refresh()} function is suitable for
updating within "reasonable periods". Two situations are considered better
to rebuild model instead of refreshing:

1. Most data is new: If initial model was trained with 100 weeks worth of
data but we add +50 weeks of new data.

2. New variables are added: If initial model had less variables than the ones
we want to start using on new refresh model.
}
\examples{
\dontrun{
# Loading dummy data
data("dt_simulated_weekly")
data("dt_prophet_holidays")
# Set the (pre-trained and exported) Robyn model JSON file
json_file <- "~/Robyn_202208081444_init/RobynModel-2_55_4.json"

# Run \code{robyn_refresh()} with 13 weeks cadence in auto mode
Robyn <- robyn_refresh(
  json_file = json_file,
  dt_input = dt_simulated_weekly,
  dt_holidays = Robyn::dt_prophet_holidays,
  refresh_steps = 13,
  refresh_mode = "auto",
  refresh_iters = 200,
  refresh_trials = 5
)

# Run \code{robyn_refresh()} with 4 weeks cadence in manual mode
json_file2 <- "~/Robyn_202208081444_init/Robyn_202208090847_rf/RobynModel-1_2_3.json"
Robyn <- robyn_refresh(
  json_file = json_file2,
  dt_input = dt_simulated_weekly,
  dt_holidays = Robyn::dt_prophet_holidays,
  refresh_steps = 4,
  refresh_mode = "manual",
  refresh_iters = 200,
  refresh_trials = 5
)
}
}
