% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MissingValue.R
\name{MV.conceptClosestFit}
\alias{MV.conceptClosestFit}
\title{Concept Closest Fit}
\usage{
MV.conceptClosestFit(decision.table)
}
\arguments{
\item{decision.table}{a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}.
Note: missing values are recognized as NA.}
}
\value{
A class \code{"MissingValue"}. See \code{\link{MV.missingValueCompletion}}.
}
\description{
It is used for handling missing values based on the concept closest fit.
}
\details{
This method is similar to the global closest fit method. The difference is
that the original data set, containing missing attribute values, is first split into
smaller data sets, each smaller data set corresponds to a concept from the original
data set. More precisely, every smaller data set is constructed from one of
the original concepts, by restricting cases to the concept.
}
\examples{
#############################################
## Example: Concept Closest Fit
#############################################
dt.ex1 <- data.frame(
     c(100.2, 102.6, NA, 99.6, 99.8, 96.4, 96.6, NA),
     c(NA, "yes", "no", "yes", NA, "yes", "no", "yes"),
     c("no", "yes", "no", "yes", "yes", "no", "yes", NA),
     c("yes", "yes", "no", "yes", "no", "no", "no", "yes"))
colnames(dt.ex1) <- c("Temp", "Headache", "Nausea", "Flu")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4,
                                    indx.nominal = c(2:4))
indx = MV.conceptClosestFit(decision.table)
}
\author{
Lala Septem Riza
}
\references{
J. Grzymala-Busse and W. Grzymala-Busse, "Handling Missing Attribute Values," in Data Mining and Knowledge Discovery Handbook,
O. Maimon and L. Rokach, Eds. New York : Springer, 2010, pp. 33-51
}
\seealso{
\code{\link{MV.missingValueCompletion}}
}

