% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxlib_get_data.R
\name{pxlib_get_data}
\alias{pxlib_get_data}
\title{Read Data from a Paradox File}
\usage{
pxlib_get_data(pxdoc)
}
\arguments{
\item{pxdoc}{An object of class \code{pxdoc_t}, representing an open Paradox file
connection. This object is obtained from \code{pxlib_open_file()}.}
}
\value{
A \code{tibble} containing the data from the Paradox file. Each row
represents a record and each column represents a field. If the file contains
no records, an empty tibble is returned.
}
\description{
Retrieves all records from an open Paradox database file and returns them
as a tibble, ready for use in R.
}
\details{
This function provides a high-level interface for reading Paradox data.
The heavy lifting is done by a C-level function (\code{R_pxlib_get_data}) which
efficiently reads the raw data into memory. This R function then acts as a
wrapper to perform crucial post-processing steps:
\itemize{
\item It identifies columns containing binary (BLOB) data and correctly
converts them into \code{blob} objects.
\item It ensures that date/time columns are properly classed for seamless
integration with other R functions.
}

The result is a clean, modern \code{tibble} that is fully compatible with the
tidyverse ecosystem.
}
\examples{
# Define the path to the demo database included with the package
db_path <- system.file("extdata", "biolife.db", package = "Rparadox")

# Open the file handle
pxdoc <- pxlib_open_file(db_path)

if (!is.null(pxdoc)) {
  # Read all data into a tibble
  biolife_data <- pxlib_get_data(pxdoc)

  # Always close the file handle when finished
  pxlib_close_file(pxdoc)

  # Work with the data
  print(biolife_data)
}
}
