% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RprobitB_parameter.R
\name{RprobitB_parameter}
\alias{RprobitB_parameter}
\title{Create object of class \code{RprobitB_parameter}.}
\usage{
RprobitB_parameter(
  P_f,
  P_r,
  J,
  N,
  alpha = NULL,
  C = NULL,
  s = NULL,
  b = NULL,
  Omega = NULL,
  Sigma = NULL,
  Sigma_full = NULL,
  beta = NULL,
  z = NULL,
  seed = NULL,
  sample = TRUE
)
}
\arguments{
\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{N}{The number (greater or equal 1) of decision makers.}

\item{alpha}{The fixed coefficient vector of length \code{P_f}.
Set to \code{NA} if \code{P_f = 0}.}

\item{C}{The number (greater or equal 1) of latent classes of decision makers.
Set to \code{NA} if \code{P_r = 0}. Otherwise, \code{C = 1} per default.}

\item{s}{The vector of class weights of length \code{C}.
Set to \code{NA} if \code{P_r = 0}.
For identifiability, the vector must be non-ascending.}

\item{b}{The matrix of class means as columns of dimension \code{P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{Omega}{The matrix of class covariance matrices as columns of dimension
\code{P_r*P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{Sigma}{The differenced error term covariance matrix of dimension
\code{J-1} x \code{J-1} with respect to alternative \code{J}.}

\item{Sigma_full}{The error term covariance matrix of dimension \code{J} x \code{J}.
Internally, \code{Sigma_full} gets differenced with respect to alternative
\code{J}, so it becomes an identified covariance matrix of dimension
\code{J-1} x \code{J-1}. If \code{Sigma} is specified, \code{Sigma_full} is
ignored.}

\item{beta}{The matrix of the decision-maker specific coefficient vectors of dimension
\code{P_r} x \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{z}{The vector of the allocation variables of length \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{seed}{Set a seed for sampling missing parameters.}

\item{sample}{A boolean, if \code{TRUE} missing parameters get sampled.}
}
\value{
An object of class \code{RprobitB_parameter}, i.e. a named list with the
model parameters \code{alpha}, \code{C}, \code{s}, \code{b}, \code{Omega},
\code{Sigma}, \code{Sigma_full}, \code{beta}, and \code{z}.
}
\description{
This function creates an object of class \code{RprobitB_parameter}.
If \code{sample = TRUE}, missing parameters are sampled. All parameters are
checked against the values of \code{P_f}, \code{P_r}, \code{J}, and \code{N}.
}
\keyword{s3}
