% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gibbs_samples.R
\name{filter_gibbs_samples}
\alias{filter_gibbs_samples}
\title{Filter Gibbs samples.}
\usage{
filter_gibbs_samples(
  x,
  P_f,
  P_r,
  J,
  C,
  cov_sym,
  keep_par = c("s", "alpha", "b", "Omega", "Sigma"),
  drop_par = NULL
)
}
\arguments{
\item{x}{An object of class \code{RprobitB_gibbs_samples}.}

\item{P_f}{The number of covariates connected to a fixed coefficient (can be 0).}

\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{J}{The number (greater or equal 2) of choice alternatives.}

\item{C}{The number of latent classes.}

\item{cov_sym}{If \code{TRUE} considers symmetric covariance matrix elements.}

\item{keep_par}{A vector of parameter names which are kept.}

\item{drop_par}{A vector of parameter names which get dropped.}
}
\value{
An object of class \code{RprobitB_gibbs_samples} filtered by the labels
\code{create_parameter_labels(P_f, P_r, J, C, cov_sym, keep_par, drop_par)}.
}
\description{
This function filters Gibbs samples.
}
\keyword{internal}
