% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_evaluation.R
\name{create_labels_Omega}
\alias{create_labels_Omega}
\title{Create labels for \code{Omega}}
\usage{
create_labels_Omega(P_r, C, cov_sym)
}
\arguments{
\item{P_r}{The number of covariates connected to a random coefficient (can be 0).}

\item{cov_sym}{Set to \code{TRUE} for labels of symmetric covariance elements.}
}
\value{
A vector of labels for the model parameter \code{Omega} of length
\code{P_r^2 * C} if \code{P_r > 0} and \code{cov_sym = TRUE}
or of length \code{P_r*(P_r+1)/2*C} if \code{cov_sym = FALSE} and \code{NULL}
otherwise.
}
\description{
This function creates labels for the model parameter \code{Omega}.
}
\details{
The labels are of the form \code{"c.p1,p2"}, where \code{c} is the latent class
number and \code{p1,p2} the indeces of two random coefficients.
}
\examples{
RprobitB:::create_labels_Omega(2, 3, cov_sym = TRUE)
RprobitB:::create_labels_Omega(2, 3, cov_sym = FALSE)
}
\keyword{internal}
