% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_class_allocation}
\alias{plot_class_allocation}
\title{Plot class allocation (for \code{P_r = 2} only)}
\usage{
plot_class_allocation(beta, z, b, Omega, ...)
}
\arguments{
\item{beta}{The matrix of the decision-maker specific coefficient vectors of dimension
\code{P_r} x \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{z}{The vector of the allocation variables of length \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{b}{The matrix of class means as columns of dimension \code{P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{Omega}{The matrix of class covariance matrices as columns of dimension
\code{P_r*P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{...}{Optional visualization parameters:
\itemize{
\item \code{colors}, a character vector of color specifications,
\item \code{perc}, a numeric between 0 and 1 to draw the \code{perc} percentile
ellipsoids for the underlying Gaussian distributions (\code{perc = 0.95} per default),
\item \code{r}, the current iteration number of the Gibbs sampler to be displayed in the legend,
\item \code{sleep}, the number of seconds to pause after plotting.
}}
}
\value{
No return value. Draws a plot to the current device.
}
\description{
This function plots the allocation of decision-maker specific coefficient vectors
\code{beta} given the allocation vector \code{z}, the class means \code{b},
and the class covariance matrices \code{Omega}.
}
\details{
Only applicable in the two-dimensional case, i.e. only if \code{P_r = 2}.
}
\examples{
b <- matrix(c(-1,1,1,1), ncol = 2)
Omega <- matrix(c(0.8,0.5,0.5,1,0.5,-0.2,-0.2,0.3), ncol = 2)
z <- rep(1:2, each = 10)
beta <- sapply(z, function(z) rmvnorm(mu = b[,z], Sigma = matrix(Omega[,z], ncol = 2)))
RprobitB:::plot_class_allocation(beta = beta, z = z, b = b, Omega = Omega,
                                 colors = c("red","blue"), perc = 0.5, r = 1)
}
\keyword{internal}
