% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{mml}
\alias{mml}
\title{Approximate marginal model likelihood}
\usage{
mml(x, S = 0, ncores = parallel::detectCores() - 1, recompute = FALSE)
}
\arguments{
\item{x}{An object of class \code{RprobitB_fit}.}

\item{S}{The number of prior samples for the prior arithmetic mean estimate. Per
default, \code{S = 0}. In this case, only the posterior samples are used
for the approximation via the posterior harmonic mean estimator, see the
details section.}

\item{ncores}{Computation of the prior arithmetic mean estimate is parallelized, set the
number of cores.}

\item{recompute}{Set to \code{TRUE} to recompute the likelihood.}
}
\value{
The object \code{x}, including the object \code{mml}, which is the model's
approximated marginal likelihood value.
}
\description{
This function approximates the model's marginal likelihood.
}
\details{
The model's marginal likelihood \eqn{p(y\mid M)} for a model \eqn{M} and data
\eqn{y} is required for the computation of Bayes factors. In general, the
term has no closed form and must be approximated numerically.

This function uses the posterior Gibbs samples to approximate the model's
marginal likelihood via the posterior harmonic mean estimator.
To check the convergence, call \code{plot(x$mml)}, where \code{x} is the output
of this function. If the estimation does not seem to have
converged, you can improve the approximation by combining the value
with the prior arithmetic mean estimator. The final approximation of the
model's marginal likelihood than is a weighted sum of the posterior harmonic
mean estimate and the prior arithmetic mean estimate,
where the weights are determined by the sample sizes.
}
