% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smlx-tools.R
\name{inlineModel}
\alias{inlineModel}
\title{Inline model}
\usage{
inlineModel(srtIn, filename = NULL)
}
\arguments{
\item{srtIn}{(\emph{string}) Model in string format,}

\item{filename}{(\emph{string}) name of the model file  (by default the model is saved in a temporary file)}
}
\value{
Name of the model file
}
\description{
Save a string in a temporary file to be used as a model file
}
\examples{
\dontrun{
myModel <- inlineModel("
[LONGITUDINAL]
input = {A, k, c, a}
EQUATION:
t0    = 0
f_0   = A
ddt_f = -k*f/(c+f)
DEFINITION:
y = {distribution=normal, prediction=f, sd=a}
[INDIVIDUAL]
input = {k_pop, omega}
DEFINITION:
k = {distribution=lognormal, prediction=k_pop, sd=omega}
")
}
}
