% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpop.R
\name{simpopmlx}
\alias{simpopmlx}
\title{Population parameters simulation}
\usage{
simpopmlx(
  n = 1,
  project = NULL,
  fim = NULL,
  parameter = NULL,
  corr = NULL,
  kw.max = 100,
  outputFilename = NULL,
  sep = ",",
  seed = NULL
)
}
\arguments{
\item{n}{(\emph{integer}) the number of vectors of population parameters (default = 1),}

\item{project}{(\emph{string}) a Monolix project, assuming that the Fisher information Matrix was estimated by Monolix.}

\item{fim}{the (\emph{string}) Fisher Information Matrix estimated by Monolix. fim={"sa", "lin"} (default="sa")}

\item{parameter}{(\emph{data.frame}) a data frame with the following columns
\itemize{
\item \code{pop.param} (no default) population parameters
\item \code{sd} (no default) standard deviation of the distribution
\item \code{trans} (default ='N') distribution (N: normal, L: logNormal, G: logitnormal, P: probitnormal, R)
\item \code{lim.a}: lower bound of logit distribution (if trans != G set lim.a to NA)
\item \code{lim.b}: upper bound of logit distribution (if trans != G set lim.b to NA)
}
Only when project is not used.}

\item{corr}{(\emph{matrix}) correlation matrix of the population parameters (default = identity). Only when project is not used.}

\item{kw.max}{(\emph{integer}) maximum number of trials for generating a positive definite covariance matrix (default = 100)}

\item{outputFilename}{(\emph{string}) when defined, path where the population parameters dataframe will be saved
It must be a a file with a csv or txt extension.
If no extension is specified, file will be saved by default in csv format}

\item{sep}{(\emph{string}) file separator when outputFilename is defined (default = ",")}

\item{seed}{(\emph{integer}) initialization of the random number generator (integer) (by default a random seed will be generated)}
}
\value{
dataframe object with generated population parameters
}
\description{
Draw population parameters using the covariance matrix of the estimates
}
\details{
See http://simulx.webpopix.org/mlxr/simpopmlx/ for more details.
}
\examples{
\dontrun{
param <- data.frame(pop.param=c(1.5, 0.5, 0.02, 0.4, 0.15, 0.2, 0.7),
                    sd=c(0.2, 0.05, 0.004, 0.05, 0.02, 0.02, 0.05),
                    trans=c('N','N','N','L','L','L','N'))
pop <- simpopmlx(n=3, parameter=param)
}
}
