% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildVar.R
\name{buildVar}
\alias{buildVar}
\title{Automatic model variance building}
\usage{
buildVar(
  project = NULL,
  final.project = NULL,
  prior = NULL,
  weight = NULL,
  cv.min = 0.001,
  fix.param1 = NULL,
  fix.param0 = NULL,
  criterion = "BICc",
  linearization = F,
  remove = T,
  add = T,
  delta = c(30, 10, 5),
  omega.set = NULL,
  pop.set1 = NULL,
  pop.set2 = NULL,
  print = TRUE
)
}
\arguments{
\item{project}{a string: the initial Monolix project}

\item{final.project}{a string: the final Monolix project (default adds "_var" to the original project)}

\item{prior}{named vector of prior probabilities (default=NULL)}

\item{weight}{named vector of weights (default=NULL)}

\item{cv.min}{value of the coefficient of variation below which an individual parameter is considered fixed (default=0.001)}

\item{fix.param1}{parameters with variability that cannot be removed (default=NULL)}

\item{fix.param0}{parameters without variability that cannot be added (default=NULL)}

\item{criterion}{penalization criterion to optimize c("AIC", "BIC", "BICc", gamma) (default=BICc)}

\item{linearization}{TRUE/FALSE whether the computation of the likelihood is based on a linearization of the model (default=FALSE)}

\item{remove}{TRUE/FALSE try to remove random effects (default=TRUE)}

\item{add}{TRUE/FALSE try to add random effects (default=TRUE)}

\item{delta}{maximum difference in criteria for testing a new model (default=c(30,10,5))}

\item{omega.set}{settings to define how a variance varies during iterations of SAEM}

\item{pop.set1}{Monolix settings 1}

\item{pop.set2}{Monolix settings 2}

\item{print}{TRUE/FALSE display the results (default=TRUE)}
}
\value{
a new Monolix project with a new inter individual variability model.
}
\description{
buildVar is designed to build the best variance model for the random effects by selecting
which individual parameters vary and which ones are fixed.
}
\details{
Penalization criterion can be either a custom penalization of the form gamma*(number of parameters),
AIC (gamma=2) or BIC (gamma=log(N)).

See https://monolix.lixoft.com/rsmlx/ for more details.
}
\examples{
\dontrun{
# Build the variability model using the default settings
r1 <- buildVar(project="warfarinPK_project.mlxtran")

# Force parameter Tlag to be fixed (no variability) and parameter Cl to vary
r2 <- buildVar(project="warfarinPK_project.mlxtran", fix.param0="Tlag", fix.param1="Cl")

# Estimate the log-likelihood by linearization of the model (faster)
r3 <- buildVar(project="warfarinPK_project.mlxtran", linearization=T)

}

# See http://monolix.lixoft.com/rsmlx/buildvar/ for detailed examples of use of buildvar
# Download the demo examples here: http://monolix.lixoft.com/rsmlx/installation


}
