% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeReturnLevelsGPDFromAnalysisObj}
\alias{tsEvaComputeReturnLevelsGPDFromAnalysisObj}
\title{tsEvaComputeReturnLevelsGPDFromAnalysisObj}
\usage{
tsEvaComputeReturnLevelsGPDFromAnalysisObj(
  nonStationaryEvaParams,
  returnPeriodsInYears,
  timeIndex = -1
)
}
\arguments{
\item{nonStationaryEvaParams}{The non-stationary parameters obtained from the analysis object.}

\item{returnPeriodsInYears}{The return periods for which to compute the return levels, expressed in years.}

\item{timeIndex}{Temporal index corresponding to the time step on which compute the GEV RLs.}
}
\value{
A list with the following components:
\describe{
\item{\code{returnLevels}}{A vector of return levels corresponding to the specified return periods.}
\item{\code{returnLevelsErrFit}}{A vector of standard errors for the return levels estimated based on the fit.}
\item{\code{returnLevelsErrTransf}}{A vector of standard errors for the return levels estimated based on the transformed parameters.}
}
}
\description{
\code{tsEvaComputeReturnLevelsGPDFromAnalysisObj} is a function that calculates the return levels for a Generalized Pareto Distribution (GPD) using the parameters obtained from an analysis object. It takes into account non-stationarity by considering time-varying parameters and their associated standard errors.
}
\examples{
# Example usage with some sample data
nonStationaryEvaParams <- list(NA,list(
 parameters = list(
   epsilon = 0.1,
   sigma = c(2.1, 2.2, 2.3),
   threshold = c(1.1, 1.2, 1.3),
   timeHorizonStart=as.POSIXct("1951-01-01"),
   timeHorizonEnd=as.POSIXct("2020-12-31"),
   nPeaks=90

 ),
 paramErr = list(
   epsilonErr = 0.01,
   sigmaErr = c(0.11, 0.12, 0.13),
   thresholdErr = c(0.011, 0.012, 0.013)
 )
)
)
returnPeriodsInYears <- c(1, 5, 10, 20, 50)
timeIndex=1
results <- tsEvaComputeReturnLevelsGPDFromAnalysisObj(nonStationaryEvaParams, returnPeriodsInYears)
head(results$returnLevels)
}
\seealso{
\code{\link{tsEvaComputeReturnLevelsGPD}}
}
