% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgDijkstra.r
\name{vcgGeodist}
\alias{vcgGeodist}
\title{Compute pseudo-geodesic distance between two points on a mesh}
\usage{
vcgGeodist(x, pt1, pt2)
}
\arguments{
\item{x}{triangular mesh of class \code{mesh3d}}

\item{pt1}{3D coordinate on mesh or index of vertex}

\item{pt2}{3D coordinate on mesh or index of vertex}
}
\value{
returns the geodesic distance between \code{pt1} and \code{pt2}.
}
\description{
Compute pseudo-geodesic distance between two points on a mesh
}
\note{
Make sure to have a clean manifold mesh. Note that this computes the length of the pseudo-geodesic path (following the edges) between the two vertices closest to these points.
}
\examples{
\dontrun{
data(humface)
pt1 <- humface.lm[1,]
pt2 <- humface.lm[5,]
vcgGeodist(humface,pt1,pt2)
}
}
