% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss-package.R
\docType{package}
\name{Rwtss-package}
\alias{Rwtss-package}
\alias{_PACKAGE}
\alias{Rwtss}
\title{Rwtss}
\description{
An R client to the web time series service (WTSS)
}
\section{Rwtss API}{


Implements an R interface to a web time series service (WTSS) 
that offers time series of remote sensing data using a simple API. 
A WTSS server takes as input an Earth observation data cube, 
that has a spatial and a temporal dimension 
and can be multidimensional in terms of its attributes.

The WTSS API has four commands: 
\itemize{
   \item `wtss`: given an URL, creates a connection to a WTSS service
   \item `list_coverages`: returns a list of coverages (cubes) available 
       in the WTSS server.
   \item `describe_coverage`: returns the metadata for a given coverage.
   \item `time_series`: returns a time series for a spatio-temporal location.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/e-sensing/Rwtss/}
  \item Report bugs at \url{https://github.com/e-sensing/Rwtss/issues}
}

}
\author{
\strong{Maintainer}: Felipe Souza \email{lipecaso@gmail.com}

Authors:
\itemize{
  \item Gilberto Queiroz \email{gilberto.queiroz@inpe.br} (\href{https://orcid.org/0000-0001-7534-0219}{ORCID})
  \item Gilberto Camara \email{gilberto.camara@inpe.br} (\href{https://orcid.org/0000-0002-3681-487X}{ORCID})
  \item Pedro Andrade \email{pedro.andrade@inpe.br} (\href{https://orcid.org/0000-0001-8675-4046}{ORCID})
  \item Luiz Assis \email{luiz.assis@inpe.br}
}

}
