% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-introspect.R
\name{method_explain}
\alias{method_explain}
\title{Explain method dispatch}
\usage{
method_explain(generic, class = NULL, object = NULL)
}
\arguments{
\item{generic}{A generic function, i.e. an \link[=new_generic]{S7 generic},
an \link[=new_external_generic]{external generic}, an \link[=UseMethod]{S3 generic},
or an \link[methods:setGeneric]{S4 generic}.}

\item{class, object}{Perform introspection either with a \code{class}
(processed with \code{\link[=as_class]{as_class()}}) or a concrete \code{object}. If \code{generic} uses
multiple dispatch then both \code{object} and \code{class} must be a list of
classes/objects.}
}
\value{
Nothing; this function is called for it's side effects.
}
\description{
\code{method_explain()} shows all possible methods that a call to a generic
might use, which ones exist, and which one will actually be called.

Note that method dispatch uses a string representation of each class in
the class hierarchy. Each class system uses a slightly different convention
to avoid ambiguity.
\itemize{
\item S7: \code{pkg::class} or \code{class}
\item S4: \code{S4/pkg::class} or \code{S4/class}
\item S3: \code{class}
}
}
\examples{
foo1 <- new_class("foo1")
foo2 <- new_class("foo2", foo1)

add <- new_generic("add", c("x", "y"))
method(add, list(foo2, foo1)) <- function(x, y) c(2, 1)
method(add, list(foo1, foo1)) <- function(x, y) c(1, 1)

method_explain(add, list(foo2, foo2))
}
