% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FX.R
\name{FXSwap-class}
\alias{FXSwap}
\title{FX Swap Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the trade belongs to}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{Ei}{The number of years that the trade will expire}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}
}
\value{
An object of type FXSwap
}
\description{
Creates an FX Swap object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}
\examples{
tr1 = FXSwap(Notional=10000,MtM=30,ccyPair="EUR/USD",Si=0,Ei=10,BuySell='Buy')
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}

