% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samHL.R
\name{predict.samHL}
\alias{predict.samHL}
\title{Prediction function for S3 class \code{"samHL"}}
\usage{
\method{predict}{samHL}(object, newdata, thol = 0, ...)
}
\arguments{
\item{object}{An object with S3 class \code{"samHL"}.}

\item{newdata}{The testing dataset represented in a \code{n} by \code{d} matrix, where \code{n} is testing sample size and \code{d} is dimension.}

\item{thol}{The decision value threshold for prediction. The default value is 0.5}

\item{\dots}{System reserved (No specific usage)}
}
\value{
\item{values}{
  Predicted decision values also represented in a \code{n} by the length of \code{lambda} matrix, where \code{n} is testing sample size.
}
\item{labels}{
  Predicted labels also represented in a \code{n} by the length of \code{lambda} matrix, where \code{n} is testing sample size. }
}
\description{
Predict the labels for testing data.
}
\details{
The testing dataset is rescale to the samHLe range, and expanded by the samHLe spline basis functions as the training data.
}
\seealso{
\code{\link{samHL}}
}
