% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydroProcess.R
\name{hydroProcess}
\alias{hydroProcess}
\title{Hydro-process a DEM}
\usage{
hydroProcess(
  DEM,
  breach_dist,
  streams = NULL,
  burn_dist = 10,
  save_path = NULL,
  n.cores = NULL,
  force_update_wbt = FALSE
)
}
\arguments{
\item{DEM}{The path to a digital elevation raster file with .tif extension, or a terra spatRaster object.}

\item{breach_dist}{The max radius (in raster cells) in which to search for a path to breach depressions, passed to \code{\link[whitebox:wbt_breach_depressions_least_cost]{whitebox::wbt_breach_depressions_least_cost()}}. This value should be high to ensure all depressions are breached, keeping in mind that greater distance = greater computing time. Note that the DEM is \emph{not} breached in order of lowest elevation to greatest, nor is it breached sequentially (order is unknown, but the raster is presumably searched in some grid pattern for depressions). This means that flow paths may need to cross multiple depressions, especially in low relief areas.}

\item{streams}{Optionally, the path to the polylines shapefile or geopackage file containing streams, which can be used to improve hydrological accuracy when using poor quality DEMs but decent accuracy stream networks.}

\item{burn_dist}{The number of units (in DEM units) to use for burning-in the stream network.}

\item{save_path}{An optional path in which to save the processed DEM. If left NULL will save it in the same directory as the provided DEM or, if the DEM is a terra object, return only terra objects.}

\item{n.cores}{The maximum number of cores to use. Leave NULL to use all cores minus 1.}

\item{force_update_wbt}{Whitebox Tools is by default only downloaded if it cannot be found on the computer, and no check are performed to ensure the local version is current. Set to TRUE if you know that there is a new version and you would like to use it.}
}
\value{
A hydro-processed DEM returned as a terra object and saved to disk if \code{save_path} is not null.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Takes a digital elevation model and prepares it for hydrological analyses, such as basin delineation. Modifies the input DEM by breaching single cell pits/depressions and then breaching remaining depressions using a least cost algorithm (where cost is a function of distance plus elevation change to the DEM).

If a streams layer is specified, a depression will be "burned-in" to the DEM along the stream path (after converting the vector file to a raster). This is very useful when trying to delineate basins with a poor resolution DEM. You can control the depth of this depression with parameter 'burn_dist'.
}
\details{
Relies on two WhiteboxTools functions: \code{\link[whitebox:wbt_fill_single_cell_pits]{whitebox::wbt_fill_single_cell_pits()}} and \code{\link[whitebox:wbt_breach_depressions_least_cost]{whitebox::wbt_breach_depressions_least_cost()}}. If the parameter \code{streams} is specified, a depression is burned into the DEM after running fill_single_cell_pits and before breaching depressions.
}
\examples{
\dontshow{if (whitebox::check_whitebox_binary()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

# Running with terra objects:
res <- hydroProcess(DEM = elev,
  breach_dist = 500,
  streams = streams,
  n.cores = 2)

terra::plot(res)

# Running with file paths:
res <- hydroProcess(DEM = system.file("extdata/dem.tif", package = "SAiVE"),
  breach_dist = 500,
  streams = system.file("extdata/streams.gpkg", package = "SAiVE"),
  n.cores = 2)

terra::plot(res)
}
\dontshow{\}) # examplesIf}
}
\author{
Ghislain de Laplante (gdela069@uottawa.ca or ghislain.delaplante@yukon.ca)
}
