% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_snapshot.R
\name{update_snapshot}
\alias{update_snapshot}
\title{Update a historical table}
\usage{
update_snapshot(
  .data,
  conn,
  db_table,
  timestamp,
  filters = NULL,
  message = NULL,
  tic = Sys.time(),
  logger = NULL,
  enforce_chronological_order = TRUE
)
}
\arguments{
\item{.data}{A tbl object. Typically a lazy query to the DB (from get_table())}

\item{conn}{An object that inherits from DBIConnection (as generated by get_connection())'}

\item{db_table}{An object that inherits from \code{tbl_dbi}, a \code{\link[DBI:Id]{DBI::Id()}} object or a character string readable by \link{id}.}

\item{timestamp}{A timestamp (POSIXct) with which to update from_ts/until_ts columns}

\item{filters}{A filter to subset data by.  if filters == NULL, no filtering occurs. Else, an inner_join is performed using all columns of the filter}

\item{message}{A message to add to the log-file (useful for supplying metadata to the log)}

\item{tic}{A timestamp when computation began. If not supplied, it will be created at call-time.
(Used to more accurately convey how long runtime of the update process has been)}

\item{logger}{A \link{Logger} instance. If none is given, one is initialized with default arguments.}

\item{enforce_chronological_order}{A logical that controls whether or not to check if timestamp of update is prior to timestamps in the DB}
}
\value{
No return value, called for side effects
}
\description{
Update a historical table
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

data <- dplyr::copy_to(conn, mtcars)

update_snapshot(data,
                conn = conn,
                db_table = "test.mtcars",
                timestamp = Sys.time())

close_connection(conn)
}
\seealso{
filter_keys
}
