% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory_inference.R
\name{infer_initial_trajectory}
\alias{infer_initial_trajectory}
\title{Infer an initial trajectory through space}
\usage{
infer_initial_trajectory(space, k)
}
\arguments{
\item{space}{A numeric matrix or data frame containing the coordinates of samples.}

\item{k}{The number of clusters to cluster the data into.}
}
\value{
the initial trajectory obtained by this method
}
\description{
\code{infer_initial_trajectory} infers an initial trajectory for
\code{\link{infer_trajectory}} by clustering the points and calculating
the shortest path through cluster centers. The shortest path takes into account
the euclidean distance between cluster centers, and the density between those two
points.
}
\examples{
## Generate an example dataset and visualise it
dataset <- generate_dataset(type = "poly", num_genes = 500, num_samples = 1000, num_groups = 4)
space <- reduce_dimensionality(dataset$expression, correlation_distance, ndim=2)
draw_trajectory_plot(space, progression_group = dataset$sample_info$group_name)

## Infer a trajectory through this space
init_traj <- infer_initial_trajectory(space, k = 4)

## Visualise the trajectory
draw_trajectory_plot(space, path = init_traj, progression_group = dataset$sample_info$group_name)
}
