% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{generate_dataset}
\alias{generate_dataset}
\title{Generate a synthetic dataset}
\usage{
generate_dataset(
  type = c("splines", "polynomial"),
  num_samples = 400,
  num_genes = 500,
  num_groups = 4
)
}
\arguments{
\item{type}{The type of function used in order to generate the expression data. Must be either \code{"splines"} (default) or \code{"polynomial"} (or abbreviations thereof).}

\item{num_samples}{The number of samples the dataset will contain.}

\item{num_genes}{The number of genes the dataset will contain.}

\item{num_groups}{The number of groups the samples will be split up in.}
}
\value{
A list containing the expression data and the meta data of the samples.
}
\description{
\code{generate_dataset} generates an synthetic dataset which can be used for visualisation purposes.
}
\examples{
## Generate a dataset
dataset <- generate_dataset(type = "poly", num_genes = 500, num_samples = 1000, num_groups = 4)

## Reduce dimensionality and infer trajectory with SCORPIUS
dist <- correlation_distance(dataset$expression)
space <- reduce_dimensionality(dist, ndim=2)
traj <- infer_trajectory(space)

## Visualise
draw_trajectory_plot(space, path=traj$path, progression_group=dataset$sample_info$group_name)
}
\seealso{
\code{\link{correlation_distance}}, \code{\link{reduce_dimensionality}}, \code{\link{infer_trajectory}}, \code{\link{draw_trajectory_plot}}
}
