% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{plot.Pred.SDALGCP}
\alias{plot.Pred.SDALGCP}
\title{plot.Pred.SDALGCP function}
\usage{
\method{plot}{Pred.SDALGCP}(x, type = "relrisk", continuous = NULL,
  thresholds = NULL, bound = NULL, ...)
}
\arguments{
\item{x}{an object of class "Pred.SDALGCP" obtained as result of a call to \code{\link{SDALGCPPred}}.}

\item{type}{Character string: what type of plot to produce. For discrete inference choices are "incidence" (=exp(mu+S)); "SEincidence" (standard error of incidence); "CovAdjRelRisk" (=exp(S)); or "SECovAdjRelRisk" (standard error of covariate adjusted relative risk); while for continuous inference, choices are "relrisk" (=exp(S)); "SErelrisk" (standard error of the relative risk).}

\item{continuous}{logical; TRUE for spatially continuous relative risk and FALSE for region specific relative risk. default is TRUE}

\item{thresholds}{optional; (only used if you want to plot the exceedance probability) either a vector  of numbers or a vector of single value.}

\item{bound}{optional; it gives the boundary of the region, only useful when the predictive location is supplied in \link{SDALGCPPred}}

\item{...}{further arguments passed to \link{plot}.}
}
\value{
The function does not return any value.
}
\description{
Simple plotting function for both discrete and continuous prediction from the object of class "Pred.SDALGCP".
}
\details{
This function plots the inference from \code{\link{SDALGCPPred}} function. It plots for region-specific inference; incidence and covariate adjusted relative risk while for spatially continuous inference it plots the relative risk. It can as well plot the exceedance probability for spatially discrete and continuous inference.
}
\examples{
### Prepare the input of the model
data(PBCshp)
data <- as.data.frame(PBCshp@data)  #get the data
### Write the formula of the model
FORM <- X ~ propmale + Income + Employment + Education + Barriers + Crime + 
Environment +  offset(log(pop)) 
### set the discretised phi
phi <- seq(500, 1700, length.out = 20)   
#### get the initial parameter
model <- glm(formula=FORM, family="poisson", data=data)
beta.start <-coef(model)
sigma2.start <- mean(model$residuals^2)
phi.start <- median(phi)
par0 <- c(beta.start, sigma2.start, phi.start)
# setup the control arguments for the MCMC
n <- 545
h <- 1.65/(n^(1/6))
control.mcmc <- controlmcmcSDA(n.sim = 10000, burnin = 2000, 
                 thin= 8, h=h, c1.h = 0.01, c2.h = 1e-04)
###Run the model
\donttest{
my_est <- SDALGCPMCML(formula=FORM, data=data, my_shp=PBCshp, delta=100, phi=phi, method=1, 
                     weighted=FALSE,  plot=TRUE, par0=NULL, control.mcmc=control.mcmc)
Con_pred <- SDALGCPPred(para_est=my_est,  cellsize=300, continuous=TRUE)
#to plot the spatially continuous relative risk
plot(Con_pred, type="relrisk")
#to plot the incidence
plot(Con_pred, type="incidence", continuous=FALSE)
#to plot the exceedance probability of the relative risk
plot(Con_pred, type="relrisk", thresholds= 2)
#to plot the exceedance probability of the incidence
plot(Con_pred, type="incidence", continuous=FALSE, thresholds= 0.001)
}
}
\seealso{
\link{SDALGCPPred}, \link{plot_continuous}, \link{plot_discrete}, \link{plot_SDALGCPexceedance}, \link{SDALGCPexceedance}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
