% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{Aggregated_poisson_log_MCML}
\alias{Aggregated_poisson_log_MCML}
\title{Aggregated_poisson_log_MCML function}
\usage{
Aggregated_poisson_log_MCML(y, D, m, corr, par0, control.mcmc, S.sim,
  Denominator, messages)
}
\arguments{
\item{y}{the data}

\item{D}{the design matrix}

\item{m}{the offset term}

\item{corr}{the correlation matrix from exponential correlation function}

\item{par0}{the initial parameter of the fixed effects beta, the variance sigmasq and the scale parameter phi, specified as c(beta, sigma2, phi)}

\item{control.mcmc}{output from \code{\link{controlmcmcSDA}}.}

\item{S.sim}{the posterior sample of the linear predictor given the initial parameters}

\item{Denominator}{the value of the denominator of the likelihood}

\item{messages}{logical; if message=TRUE, it prints the results objective function and the parameters at every phi iteration. Default is FALSE.}
}
\value{
\code{estimate}: estimates of the model parameters; beta's and with sigma2 on the log scale

\code{covariance}: covariance matrix of the MCML estimates.

\code{log.lik}: maximum value of the log-likelihood.

\code{S}: the linear predictor given the initial parameter
}
\description{
This function performs Monte Carlo maximum likelihood (MCML) estimation for the geostatistical Poisson model with log link function.
}
\details{
The function helps to obtain the MCML estimate for a given value of correlation matrix, i.e for a given value of the scale parameter phi.
}
\references{
Giorgi, E., & Diggle, P. J. (2017). PrevMap: an R package for prevalence mapping. Journal of Statistical Software, 78(8), 1-29. doi:10.18637/jss.v078.i08.

Christensen, O. F. (2004). Monte Carlo maximum likelihood in model-based geostatistics. Journal of Computational and Graphical Statistics 13, 702-718.
}
\seealso{
\code{\link{controlmcmcSDA}}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
