% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils.R
\name{Rule.compatibility}
\alias{Rule.compatibility}
\title{Return the compatibility degrees of a rule with all instances of a given dataset.}
\usage{
Rule.compatibility(example, rule_cat, rule_num, catParticip, numParticip, xmin,
  xmedio, xmax, n_matrices, max_cat, max_num, t_norm)
}
\arguments{
\item{example}{The instances of the dataset, a matrix with one example PER COLUMN and without the CLASS ATTRIBUTE.}

\item{rule_cat}{Part of the rule with the categorical values.}

\item{rule_num}{Part of the rule with the numerical values.}

\item{catParticip}{vector indicating which categorical attributes participate in the rule and so, they must be evaluated.}

\item{numParticip}{vector indicating which numerical attributes participate in the rule and so, they must be evaluated.}

\item{xmin}{numeric vector which indicate the minimum value of the fuzzy sets of every numeric attribute that participate in the rule.}

\item{xmedio}{numeric vector which indicate the medium value of the fuzzy sets of every numeric attribute that participate in the rule.}

\item{xmax}{numeric vector which indicate the maximum value of the fuzzy sets of every numeric attribute that participate in the rule.}

\item{n_matrices}{number of fuzzy sets that there are in the rule (The length of vectors xmin, xmedio and xmax)}

\item{max_cat}{numeric vector indicating the maximum value of categorical values.}

\item{max_num}{numeric vector indicating the maximum value for fuzzy partitions on every attribute}

\item{t_norm}{The T-norm to use to compute the compatibility degree. 0 for minimum t-norm. Other value for product t-norm}
}
\value{
A vector with length 'number of examples' indicating their compatibility degree.
}
\description{
The rules passed to this functions MUST have a vector representation in CANONICA form. This function
was made for being used mainly for the FuGePSD algorithm.
}

