% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridSearch.R
\name{gridSearch}
\alias{gridSearch}
\title{Grid Search}
\usage{
gridSearch(model, hypers, metric, test = NULL, bg4test = NULL,
  env = NULL, parallel = FALSE, save_models = TRUE, seed = NULL)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}

\item{hypers}{named list containing the values of the hyperparameters that
should be tuned, see details.}

\item{metric}{character. The metric used to evaluate the models, possible
values are: "auc", "tss" and "aicc".}

\item{test}{\linkS4class{SWD} object. Test dataset used to evaluate the
model, not used with \code{\link{aicc}} and \linkS4class{SDMmodelCV} objects,
default is \code{NULL}.}

\item{bg4test}{\linkS4class{SWD} object or NULL. Background locations used to
get subsamples if the \strong{a} hyperparameter is tuned, default is \code{NULL}.}

\item{env}{\code{\link[raster]{stack}} containing the environmental
variables, used only with "aicc", default is \code{NULL}.}

\item{parallel}{logical, if \code{TRUE} it uses parallel computation, default
is \code{FALSE}.}

\item{save_models}{logical, if \code{FALSE} the models are not saved and the
output contains only a data frame with the metric values for each
hyperparameter combination. Default is \code{TRUE}, set it to \code{FALSE}
when there are many combinations to avoid R crashing for memory overload.}

\item{seed}{numeric. The value used to set the seed to have consistent
results, default is \code{NULL}.}
}
\value{
\linkS4class{SDMtune} object.
}
\description{
Given a set of possible hyperparameter values, the function trains models
with all the possible combinations of hyperparameters.
}
\details{
To know which hyperparameters can be tune you can use the output of
the function \code{\link{get_tunable_args}}. Parallel computation increases
the speed only for large datasets due to the time necessary to create the
cluster.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(presence, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", p = train, a = bg, fc = "l")

# Define the hyperparameters to test
h <- list(reg = 1:2, fc = c("lqp", "lqph"), a = c(1000, 2000))

# Run the function using as metric the AUC
output <- gridSearch(model, hypers = h, metric = "auc", test = test,
                     bg4test = bg)
output@results
output@models
# Order rusults by highest test AUC
head(output@results[order(-output@results$test_AUC), ])

# Run the function using as metric the AICc and without saving the trained
# models, helpful when numerous hyperparameters are tested to avoid memory
# problems
output <- gridSearch(model, hypers = h, metric = "aicc", bg4test = bg,
                     env = predictors, save_models = FALSE)
output@results
}
}
\seealso{
\code{\link{randomSearch}} and \code{\link{optimizeModel}}
}
\author{
Sergio Vignali
}
