% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss.R
\name{tss}
\alias{tss}
\title{True Skill Statistics}
\usage{
tss(model, test = NULL)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}

\item{test}{\linkS4class{SWD} test locations for \linkS4class{SDMmodel}
objects or logical for \linkS4class{SDMmodelCV} objects, if not provided it
computes the training AUC, default is \code{NULL}.}
}
\value{
The value of the TSS of the given model.
}
\description{
Compute the max TSS of a given model.
}
\details{
If the model is a \linkS4class{SDMmodelCV} object, the function
computes the mean of the training or testing TSS values of the different
replicates.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(presence, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", p = train, a = bg, fc = "l")

# Compute the training TSS
tss(model)

# Compute the testing TSS
tss(model, test)

\donttest{
# Same example but using cross validation instead of training and testing
# datasets
model <- train(method = "Maxnet", p = presence, a = bg, fc = "l", rep = 4,
               seed = 25)

# Compute the training TSS
TSS(model)

# Compute the testing TSS
TSS(model, test = TRUE)
}
}
\references{
Allouche O., Tsoar A., Kadmon R., (2006). Assessing the accuracy of species
distribution models: prevalence, kappa and the true skill statistic (TSS).
Journal of Applied Ecology, 43(6), 1223–1232.
}
\author{
Sergio Vignali
}
