% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizeModel.R
\name{optimizeModel}
\alias{optimizeModel}
\title{Optimize Model}
\usage{
optimizeModel(model, hypers, metric, test = NULL, bg4test = NULL,
  pop = 20, gen = 5, env = NULL, parallel = FALSE,
  keep_best = 0.4, keep_random = 0.2, mutation_chance = 0.4,
  seed = NULL)
}
\arguments{
\item{model}{\code{\linkS4class{SDMmodel}} or \code{\linkS4class{SDMmodelCV}}
object.}

\item{hypers}{named list containing the values of the hyperparameters that
should be tuned, see details.}

\item{metric}{character. The metric used to evaluate the models, possible
values are: "auc", "tss" and "aicc".}

\item{test}{\code{\linkS4class{SWD}} object. Test dataset used to evaluate
the model, not used with aicc and \code{\linkS4class{SDMmodelCV}} objects,
default is \code{NULL}.}

\item{bg4test}{Deprecated.}

\item{pop}{numeric. Size of the population, default is 5.}

\item{gen}{numeric. Number of generations, default is 20.}

\item{env}{\code{\link[raster]{stack}} containing the environmental
variables, used only with "aicc", default is \code{NULL}.}

\item{parallel}{logical, if \code{TRUE} it uses parallel computation, default
is \code{FALSE}.}

\item{keep_best}{numeric. Percentage of the best models in the population to
be retained during each iteration, expressed as decimal number. Default
is 0.4.}

\item{keep_random}{numeric. Probability of retaining the excluded models
during each iteration, expressed as decimal number. Default is 0.2.}

\item{mutation_chance}{numeric. Probability of mutation of the child models,
expressed as decimal number. Default is 0.4.}

\item{seed}{numeric. The value used to set the seed to have consistent
results, default is \code{NULL}.}
}
\value{
\code{\linkS4class{SDMtune}} object.
}
\description{
The function uses a Genetic Algorithm implementation to optimize the model
hyperparameter configuration according to the chosen metric.
}
\details{
To know which hyperparameters can be tuned you can use the output of
the function \code{\link{get_tunable_args}}. Hyperparameters not included in
the \code{hypers} argument take the value that they have in the passed model.
Parallel computation increases the speed only for large datasets due to the
time necessary to create the cluster. Part of the code is inspired by
\href{https://blog.coast.ai/lets-evolve-a-neural-network-with-a-geneticalgorithm-code-included-8809bece164}{this post}.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxent", data = train, fc = "l")

# Define the hyperparameters to test
h <- list(reg = 1:3, fc = c("lqp", "lqph", "lh"), iter = seq(300, 700, 100))

# Run the function using as metric the AUC
output <- optimizeModel(model, hypers = h, metric = "auc", test = test,
                        seed = 25)
output@results
output@models
output@models[[1]]  # Best model
}
}
\seealso{
\code{\link{gridSearch}} and \code{\link{randomSearch}}.
}
\author{
Sergio Vignali
}
