% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-SDMmodelCV.R
\name{predict,SDMmodelCV-method}
\alias{predict,SDMmodelCV-method}
\title{Predict for Cross Validation}
\usage{
\S4method{predict}{SDMmodelCV}(
  object,
  data,
  fun = "mean",
  type = NULL,
  clamp = TRUE,
  filename = "",
  format = "GTiff",
  extent = NULL,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{SDMmodelCV} object.}

\item{data}{data.frame, \linkS4class{SWD} or raster \link[raster]{stack} with
the data for the prediction.}

\item{fun}{character. function used to combine the output of the k models,
default is \code{"mean"}. Note that fun is a character argument, you must use
\code{"mean"} and not \code{mean}. You can also pass a vector of character containing
multiple function names, see details.}

\item{type}{character. Output type, see details, used only for \strong{Maxent} and
\strong{Maxnet} methods, default is \code{NULL}.}

\item{clamp}{logical for clumping during prediction, used only for \strong{Maxent}
and \strong{Maxnet} methods, default is \code{TRUE}.}

\item{filename}{character. Output file name for the prediction map, used only
when \code{data} is a \link[raster]{stack} object. If provided the output is saved
in a file, see details.}

\item{format}{character. The output format, see \link[raster]{writeRaster}
for all the options, default is "GTiff".}

\item{extent}{\link[raster]{extent} object, if provided it restricts the
prediction to the given extent, default is \code{NULL}.}

\item{parallel}{deprecated.}

\item{...}{Additional arguments to pass to the \link[raster]{writeRaster}
function.}
}
\value{
A vector with the prediction or a \link[raster]{raster} object if
data is a raster \link[raster]{stack} or a list in the case of multiple
functions.
}
\description{
Predict the output for a new dataset given a trained \linkS4class{SDMmodelCV}
model. The output is given as the provided function applied to the prediction
of the k models.
}
\details{
\itemize{
\item filename, format, extent, and ... arguments are used only when the
prediction is done for a \link[raster]{stack} object.
\item When a character vector is passed to the \code{fun} argument, than all the
given functions are applied and a named list is returned, see examples.
\item When \code{filename} is provided and the \code{fun} argument contains more than one
function name, the saved files are named as \code{filename_fun}, see example.
\item For models trained with the \strong{Maxent} method the argument \code{type} can be:
"raw", "logistic" and "cloglog". The function performs the prediction in
\strong{R} without calling the \strong{MaxEnt} Java software. This results in a faster
computation for large datasets and might result in a slightly different
output compared to the Java software.
\item For models trained with the \strong{Maxnet} method the argument \code{type} can be:
"link", "exponential", "logistic" and "cloglog", see \link[maxnet]{maxnet}
for more details.
\item For models trained with the \strong{ANN} method the function uses the "raw"
output type.
\item For models trained with the \strong{RF} method the output is the probability of
class 1.
\item For models trained with the \strong{BRT} method the function uses the number of
trees defined to train the model and the "response" output type.
}
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Create 4 random folds splitting only the presence data
folds <- randomFolds(data, k = 4, only_presence = TRUE)
model <- train(method = "Maxnet", data = data, fc = "l", folds = folds)

# Make cloglog prediction for the all study area and get the result as
# average of the k models
predict(model, data = predictors, fun = "mean", type = "cloglog")

# Make cloglog prediction for the all study area, get the average, standard
# deviation, and maximum values of the k models, and save the output in three
# files
\dontrun{
# The following commands save the output in the working directory
maps <- predict(model, data = predictors, fun = c("mean", "sd", "max"),
                type = "cloglog", filename = "prediction")
# In this case three files are created: prediction_mean.tif,
# prediction_sd.tif and prediction_max.tif

plotPred(maps$mean)
plotPred(maps$sd)
plotPred(maps$max)

# Make logistic prediction for the all study area, given as standard
# deviation of the k models, and save it in a file
predict(model, data = predictors, fun = "sd", type = "logistic",
        filename = "my_map")
}
}
}
\references{
Wilson P.D., (2009). Guidelines for computing MaxEnt model output
values from a lambdas file.
}
\author{
Sergio Vignali
}
