% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targetlabeling.R
\name{targetlabeling}
\alias{targetlabeling}
\title{Labeling the Target Gene in the Splicing Efficiency List}
\usage{
targetlabeling(
  SEresultlist,
  target_site = "48753008",
  target_label = "CARD8",
  xlim.max = 100,
  ylim.max = 100
)
}
\arguments{
\item{SEresultlist}{a large list created by SEcalculation}

\item{target_site}{a character indicating target splicing site position}

\item{target_label}{a character indicating the label you want to add}

\item{xlim.max}{a numeric value indicating the max x axis}

\item{ylim.max}{a numeric value indicating the max y axis}
}
\value{
a data frame of the target information
}
\description{
Labeling the Target Gene in the Splicing Efficiency List
}
\examples{
targetlabeling(SEresultlist,target_site = "27830321",target_label = "RPL21",
xlim.max = 1000, ylim.max = 1000)
}
