% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dx}
\alias{dx}
\title{Difference for Pairs - D(x)}
\usage{
dx(x, g1, g2, d, s, ymax, xlab, color)
}
\arguments{
\item{x}{a column vector of scores on which the D(x) is conditioned}

\item{g1}{a column vector of equated scores based on a single subpopulation (aligned with elements in x)}

\item{g2}{a column vector of equated scores based on a different single subpopulation (aligned with elements in x)}

\item{d}{a scalar of the positive difference that matters (negative of d will be applied as the negative difference that matters)}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized D(x))}

\item{ymax}{A maximum value for the y axis of the plot (default = 3 + the maximum D(x) value)(negative of ymax will be applied to ymin of plot)}

\item{xlab}{A label for the x axis of the plot (default = Score Scale)}

\item{color}{color of D(x) line and points on plot (default = red)}
}
\value{
A data frame of D(x) indices, conditioned on the score scale

A plot of the D(x) indices in reference to the difference that matters
}
\description{
The difference index, \eqn{D(x)}{D(x)}, for pairs is the simple arithmetic difference between one subpopulation's conditional equated score, \eqn{y_j(x)}{y_j(x)},and another subpopulation's conditional equated score, \eqn{y_{j'}(x)}{y_j'(x)}. Formally,
\deqn{D(x)=\frac{y_j(x)-y_{j'}(x)}{\sigma_x},}{(y_j(x)-y_j'(x))/s,}
where \eqn{x}{x} is a score on the original (i.e., not equated) scale and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores in the (sub)population of interest. It is considered a pairwise, conditional invariance method. It was adapted by Huggins and Penfield (2012) from the analogous unconditional index, \eqn{MD}{MD}, presented by Kolen and Brennan (2004). It provides practitioners with the direction and magnitude of equated score differences between a pair of subpopulations at each level of the original scale.
}
\examples{
#Unstandardized D(x) for subpopulation 1 and subpopulation 2 in the example data set, ex.data
dx(x=ex.data[,1],g1=ex.data[,3],g2=ex.data[,4],d=.5)

#Unstandardized D(x) for subpopulation 1 and subpopulation 2 in the example data set, ex.data, 
#with adjustments to the maximum y-axis on the plot, a new xlabel, and points/line in blue.
dx(x=ex.data[,1],g1=ex.data[,3],g2=ex.data[,4],d=.5,ymax=2,xlab="AD(x)",color="blue")

#Unstandardized D(x) for subpopulation 4 and subpopulation 5 in the example data set, ex.data
dx(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],d=.5)

#Standardized D(x) for subpopulation 4 and subpopulation 5 in the example data set, ex.data
dx(x=ex.data[,1],g1=ex.data[,6],g2=ex.data[,7],d=.5,s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Huggins, A.C., & Penfield, R.D. (2012). An NCME instructional module on population invariance in linking and equating. Educational Measurement: Issues and Practices, 31, 27-40.}
\item{Kolen, M.J., & Brennan, R.L. (2004). Test equating, scaling, and linking: Methods and practices (2nd ed.). NY: Springer.}
}
}
\seealso{
\code{\link{mdp}}
}

