% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pc}
\alias{pc}
\title{Plot a Single or Multiple Conditional Indices}
\usage{
pc(con, n, s, d, connames, ylab, xlab, colc, pchc, yleg, xleg, ylim)
}
\arguments{
\item{con}{a concatenated series of data frames produced by SEAsic functions for (up to 6) conditional indices}

\item{n}{scalar indicating the number of conditional indices in the plot}

\item{s}{scalar representing the standard deviation of equated scores in the overall population, or on any (sub)population of interest (e.g., synthetic population) (default is 1, which should be used when plotting unstandardized indices)}

\item{d}{unstandardized difference that matters}

\item{connames}{a row vector of quoted names for the conditional indices}

\item{ylab}{a quoted label for the y axis (default is "Equating Dependence")}

\item{xlab}{a quoted label for the x axis (default is "Score Scale")}

\item{colc}{a color designation for the conditional indices (default is a series of n rainbow colors)}

\item{pchc}{a row vector of shape designation for the conditional index data points (default is filled circle)}

\item{yleg}{a scalar indicating the value of the y axis at which the legend should sit (default is the maximum conditional index value for the first data frame in con)}

\item{xleg}{a scalar indicating the value of the x axis at which the legend should sit (default is the minimum value of the score scale in the first data frame in con)}

\item{ylim}{a row vector length of 2 with the minimum and maximum values for the y axis (default set at finite values in the plot)}
}
\value{
plot of multiple conditional indices
}
\description{
Function can be used to place a single or multiple conditional indices onto one plot, with the ability to alter the y-axis label, x-axis label, colors for each index, shapes of data points for each index, the placement of the legend and the limits of the y-axis.
}
\note{
\itemize{
\item{All indices must be measured on the same scale (e.g., all unstandardized indices).}
\item{Plotting a single conditional index can also be done via functions to obtain the values of any conditional index, but there are more options to customize the plots via the pc function.}
}
}
\examples{
#Obtaining and plotting the unstandardized RSD(x) for all five subpopulations 
#in the example data set, ex.data
rsd_g1 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,3],d=.5)
rsd_g2 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,4],d=.5)
rsd_g3 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,5],d=.5)
rsd_g4 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,6],d=.5)
rsd_g5 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],d=.5)

pc(con=c(rsd_g1,rsd_g2,rsd_g3,rsd_g4,rsd_g5),n=5,d=.5,
connames=c("RSD Group 1","RSD Group 2","RSD Group 3","RSD Group 4","RSD Group 5"),
ylim=c(0,4),yleg=4)

#Obtaining and plotting the standardized RSD(x) for all five subpopulations 
#in the example data set, ex.data
srsd_g1 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,3],d=.5,s=4.2)
srsd_g2 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,4],d=.5,s=4.2)
srsd_g3 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,5],d=.5,s=4.2)
srsd_g4 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,6],d=.5,s=4.2)
srsd_g5 <- rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],d=.5,s=4.2)

pc(con=c(srsd_g1,srsd_g2,srsd_g3,srsd_g4,srsd_g5),n=5,d=.5,
connames=c("RSD Group 1","RSD Group 2","RSD Group 3","RSD Group 4","RSD Group 5"),
s=4.2,ylim=c(0,2),yleg=2,ylab="Standardized Equating Dependence")

#Obtaining and plotting the unstandardized RMSD(x) for all five subpopulations 
#in the example data set, ex.data
rmsd <- rmsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),w=c(.1,.2,.4,.2,.1),d=.5)

pc(con=c(rmsd),n=1,d=.5,connames=c("RMSD"),
ylim=c(0,4),yleg=4,ylab="Root Mean Square Differences")
}
\author{
Anne Corinne Huggins-Manley
}
\seealso{
\code{\link{pcu}}
}

