% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sei.R
\name{plot_sei}
\alias{plot_sei}
\title{Plot standardised indices}
\usage{
plot_sei(
  x,
  type = c("ts", "hist"),
  title = NULL,
  lab = "Std. Index",
  xlims = NULL,
  ylims = NULL,
  n_bins = 30
)
}
\arguments{
\item{x}{vector or xts object containing the indices to be plotted.}

\item{type}{type of plot (either time series "ts", or histogram "hist").}

\item{title}{optional title of the plot.}

\item{lab}{axis label.}

\item{xlims, ylims}{lower and upper limits of the axes.}

\item{n_bins}{the number of bins to show in the histogram.}
}
\value{
A ggplot object displaying the standardised index values.
}
\description{
Plot a time series containing standardised indices, or a histogram
of the indices.
}
\details{
The \code{plot_sei()} function can be used to plot either a time series (if
\code{type = "ts"}) or a histogram (if \code{type = "hist"}) of the values in \code{x}.

A time series can only be displayed if \code{x} is an \pkg{xts} time series.

The argument \code{lab} is a string containing the label of the x-axis if
\code{type = "hist"} and the y-axis if \code{type = "ts"}.
}
\examples{
data(data_supply)
# consider hourly German energy supply data in 2019
supply_de <- subset(data_supply, country == "Germany", select = c("date", "PWS"))
supply_de <- xts::xts(supply_de$PWS, order.by = supply_de$date)
supply_de_std <- std_index(supply_de, timescale = "hours")

plot_sei(supply_de, title = "German renewable energy production in 2019")
plot_sei(supply_de_std, title = "German SREPI in 2019")

plot_sei(supply_de, type = "hist", title = "German renewable energy production in 2019")
plot_sei(supply_de_std, type = "hist", title = "German SREPI in 2019")

}
\author{
Sam Allen, Noelia Otero
}
