---
output: pdf_document
fontsize: 12pt
---

\thispagestyle{empty}
\today

Dear editor, 
	
\bigskip
	
I hereby submit the research article titled ``Calculating standardised indices using SEI'' for publication in the R Journal. This manuscript is not in submission elsewhere, and the authors have no conflicts of interest to disclose.
	
\bigskip
	
This article is a vignette for the \verb!SEI! package in \verb!R!, which provides the functionality to calculate standardised indices. Standardised indices are projections of variables onto an interpretable and probabilistically meaningful scale, making them ideal for risk management and decision making. They have found applications in various fields, and are ubiquitous in the context of hydrological drought analysis. Existing software packages lack flexibility when computing standardised indices, typically restricting attention to only a few standardised climate indices. The \verb!SEI! package remedies this by providing comprehensive functionality that can be applied in much greater generality, facilitating applications of standardised variables in any domain.
	
\bigskip
	
The article motivates the use of standardised indices, thoroughly describes their theoretical background, and demonstrates the functionality of the SEI package with several examples. We discuss existing software packages and their limitations, list possible implementation options, and provide advice regarding which methods are most suitable in different circumstances. The article then illustrates how the software can be implemented in practice by applying it in two highly relevant applications in the fields of meteorology and renewable energy. The article therefore greatly facilitates the implementation of standardised indices in practical applications, rendering the manuscript suitable for publication in this journal.
		
\bigskip
	 
Material to replicate the results in this manuscript has been included in the submission.

\bigskip
	
Thank you for considering this manuscript, I look forward to hearing your response. Do not hesitate to contact me if you have any queries.
	
\bigskip
	
Sincerely, 
	
\bigskip
	
Sam Allen
    

Institute of Mathetmatical Statistics and Actuarial Science  
University of Bern  
Bern, Switzerland  
sam.allen@unibe.ch
