% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalID.R
\name{globalID}
\alias{globalID}
\title{Determines whether a mixed graph is globally identifiable.}
\usage{
globalID(graph)
}
\arguments{
\item{graph}{a \code{\link{MixedGraph}} object representing
the mixed graph.}
}
\value{
TRUE if the graph is globally identifiable, FALSE otherwise.
}
\description{
Uses the criterion in Theorem 2 of the paper by Drton, Foygel and Sullivant (2011) to determine
whether a mixed graph is globally identifiable.
}
\references{
Drton, M., Barber, R. F., and Sullivant S. (2011).
Half-Trek Criterion for Identifiability of Latent Variable Models.
Ann. Statist. 39 (2011), no. 2, 865--886 <doi:10.1214/10-AOS859>.
}
