% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roulette.R
\name{roulette}
\alias{roulette}
\title{Elicit one set of probabilities using the roulette method.}
\usage{
roulette(lower = 0, upper = 100, gridheight = 10, nbins = 10)
}
\arguments{
\item{lower}{The lower limit on the x-axis of the roulette grid.}

\item{upper}{The upper limit on the x-axis of the roulette grid.}

\item{gridheight}{The maximum number of probs that can be allocated to a
single bin.}

\item{nbins}{The number of equally sized bins drawn between \code{Lo} and
\code{Up}.}
}
\value{
A list, with outputs 
\item{v }{ upper limits of
each bin.}
\item{p }{ cumulative probabilities for each
upper bin limit.}
}
\description{
Opens a shiny app for the roulette elicitation method. The user clicks in the
grid to allocate 'probs' to 'bins'. The elicited probability inside each
bin is the proportion of probs in each bin.
}
\note{
Regarding the option ``spread end probs over empty bins'' 
(unchecked as the default): suppose for example, the leftmost and rightmost non-empty
bins are [10,20] and [70,80], and each contain one prob, with 20 probs used in total. If the option
is unchecked, it is assumed P(X<20) = P(X>70) = 0.05 and P(X<10) = P(X>80) = 0. If the option
is checked, it is assumed P(X<20) = P(X>70) = 0.05 only.
}
\examples{

\dontrun{
x <- roulette(lower = 0, upper = 100)
# Then allocate probs to bins and click "Finish"

# To fit distributions and see the results
myfit <- fitdist(vals = x$v, probs = x$p, lower = 0, upper = 100)
plotfit(myfit)
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
