% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unif.2017YMq.R
\name{unif.2017YMq}
\alias{unif.2017YMq}
\title{Multivariate Test of Uniformity based on Normal Quantiles by Yang and Modarres (2017)}
\usage{
unif.2017YMq(X, lower = rep(0, ncol(X)), upper = rep(1, ncol(X)))
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{lower}{length-\eqn{p} vector of lower bounds of the test domain.}

\item{upper}{length-\eqn{p} vector of upper bounds of the test domain.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X}, it tests
\deqn{H_0 : \Sigma_x = \textrm{ uniform on } \otimes_{i=1}^p [a_i,b_i] \quad vs\quad H_1 : \textrm{ not } H_0}
using the procedure by Yang and Modarres (2017). Originally, it tests the goodness of fit 
on the unit hypercube \eqn{[0,1]^p} and modified for arbitrary rectangular domain. Since 
this method depends on quantile information, every observation should strictly reside within 
the boundary so that it becomes valid after transformation.
}
\examples{
## CRAN-purpose small example
smallX = matrix(runif(10*3),ncol=3)
unif.2017YMq(smallX) # run the test

\donttest{
## empirical Type 1 error 
niter   = 1234
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(runif(50*5), ncol=25)
  counter[i] = ifelse(unif.2017YMq(X)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'unif.2017YMq'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{yang_multivariate_2017}{SHT}
}
