% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unif.2017YMi.R
\name{unif.2017YMi}
\alias{unif.2017YMi}
\title{Multivariate Test of Uniformity based on Interpoint Distances by Yang and Modarres (2017)}
\usage{
unif.2017YMi(
  X,
  type = c("Q1", "Q2", "Q3"),
  lower = rep(0, ncol(X)),
  upper = rep(1, ncol(X))
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{type}{type of statistic to be used, one of \code{"Q1"},\code{"Q2"}, and \code{"Q3"}.}

\item{lower}{length-\eqn{p} vector of lower bounds of the test domain.}

\item{upper}{length-\eqn{p} vector of upper bounds of the test domain.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X}, it tests
\deqn{H_0 : \Sigma_x = \textrm{ uniform on } \otimes_{i=1}^p [a_i,b_i]  \quad vs\quad H_1 : \textrm{ not } H_0}
using the procedure by Yang and Modarres (2017). Originally, it tests the goodness of fit 
on the unit hypercube \eqn{[0,1]^p} and modified for arbitrary rectangular domain.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
unif.2017YMi(smallX) # run the test

\donttest{
## empirical Type 1 error 
##   compare performances of three methods 
niter = 1234
rec1  = rep(0,niter) # for Q1
rec2  = rep(0,niter) #     Q2
rec3  = rep(0,niter) #     Q3
for (i in 1:niter){
  X = matrix(runif(50*10), ncol=50) # (n,p) = (10,50)
  rec1[i] = ifelse(unif.2017YMi(X, type="Q1")$p.value < 0.05, 1, 0)
  rec2[i] = ifelse(unif.2017YMi(X, type="Q2")$p.value < 0.05, 1, 0)
  rec3[i] = ifelse(unif.2017YMi(X, type="Q3")$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'unif.2017YMi'\n","*\n",
"* Type 1 error with Q1 : ", round(sum(rec1/niter),5),"\n",
"*                   Q2 : ", round(sum(rec2/niter),5),"\n",
"*                   Q3 : ", round(sum(rec3/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{yang_multivariate_2017}{SHT}
}
\concept{gof_uniform}
