% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getQueenYearOfBirth}
\alias{getQueenYearOfBirth}
\title{Access the queen's year of birth}
\usage{
getQueenYearOfBirth(x, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}} (one or more than one queen),
\code{\link[SIMplyBee]{Colony-class}} (one colony), or
\code{\link[SIMplyBee]{MultiColony-class}} (more colonies)}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
numeric, the year of birth of the queen(s); named when theres is more
  than one queen; \code{NA} if queen not present
}
\description{
Level 0 function that returns the queen's year of birth.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])

queen <- getQueen(colony)
queen <- setQueensYearOfBirth(queen, year = 2022)
getQueenYearOfBirth(queen)

getQueenYearOfBirth(getQueen(colony))
colony <- setQueensYearOfBirth(colony, year = 2030)
getQueenYearOfBirth(colony)

apiary <- setQueensYearOfBirth(apiary, year = 2022)
getQueenYearOfBirth(apiary)
}
